#include <stdio.h>   /* Standard input/output definitions */
#include <string.h>  /* String function definitions */
#include <unistd.h>  /* UNIX standard function definitions */
#include <fcntl.h>   /* File control definitions */
#include <errno.h>   /* Error number definitions */
#include <termios.h> /* POSIX terminal control definitions */

#define SERIALDEVICE "/dev/tty.USA19H3b1P1.1"

/*
 *      * 'open_port()' - Open serial port 1.
 *           *
 *                * Returns the file descriptor on success or -1 on error.
 *                     */

int open_port(void)
{
	int fd; /* File descriptor for the port */

	fd = open(SERIALDEVICE, O_RDWR | O_NOCTTY | O_NDELAY);
	if (fd == -1)
	{
		/*
		 * 	* Could not open the port.
		 * 		*/

		perror("open_port: Unable to open serial port  - ");
	}
	else
		fcntl(fd, F_SETFL, 0);

	return (fd);
}

int main()
{
	int n;
	int fd = open_port();
	char in[128] = {0};
	if (fd == 0) exit(-1);

        //fcntl(fd, F_SETFL, FNDELAY); // don't block
	
	n = write(fd, "ATZ\r", 4);
	printf("wrote %d chars\n",n);	
	n = read(fd,(void*)&in,sizeof(in));
	printf("read %d chars\n",n);	
	close(fd);
	return 0;
}
