/*
 * netsender, body
 *
 * C to max/msp or pd communication
 *
 * Copyright: Mark Brady 2004
 */

#include <stdio.h>
#include "netsender.h"

unsigned short netsender_init(const char * dest_ip, unsigned long dest_port, NetsenderContext* context) {
	unsigned short ok = 1;
	bzero((char*)context, sizeof(*context));
	fprintf(stderr,"netsender - initing, %d bytes zeroed\n", sizeof(*context));
	context->max_addr.sin_family = AF_INET;
	if (dest_ip) 
		context->max_addr.sin_addr.s_addr = inet_addr(dest_ip);
	else {
	    context->max_addr.sin_addr.s_addr = inet_addr("127.0.0.1");
	    fprintf(stderr,"netsender - Warning: using built-in default 'localhost' as destination IP'");
	}
	context->max_addr.sin_port = htons(dest_port);

	context->max_socket = socket(AF_INET,SOCK_DGRAM,0);
	ok = ok && context->max_socket;

	context->local_addr.sin_family = AF_INET;
	context->local_addr.sin_addr.s_addr = htons(INADDR_ANY);
	context->local_addr.sin_port = htons(0); // ANY

	ok = ok && bind(context->max_socket, (const struct sockaddr*)&(context->local_addr), sizeof(context->local_addr)) == 0;

	if (!ok) {
		close(context->max_socket);
		context->max_socket = 0; 
		fprintf(stderr,"netsender - Max/Msp Socket creation failed\n");
	} else {
		fprintf(stderr,"netsender - Max/Msp Socket creation OK\n");
	}
	return ok;
}

void netsender_shutdown(NetsenderContext *context) {
	if (context->max_socket) { close(context->max_socket); context->max_socket = 0; }
}

ssize_t netsender_sendtomax(const char *socket_data,NetsenderContext *context) {
	size_t data_len = strlen(socket_data);
	if (data_len < 2 || strcmp(";\n",socket_data + data_len - 2) != 0) {
			fprintf(stderr,"netsender - ERROR: BAD Socketdata: '%s' data must be terminated with semicolon and newline characters - data NOT sent\n",socket_data);
			return 0;
	}
	return  sendto(context->max_socket,socket_data,strlen(socket_data),0,(const struct sockaddr *) &(context->max_addr), sizeof(context->max_addr));
}
