/*  
 *  L.A. Riley 11/18/99
 *  
 *  This is a greatly modified miniterm.c 
 *  by Sven Goldt (goldt@math.tu-berlin.de) 
 *
 *  This program reads the serial interface expecting to find a Davis 
 *  Systems WeatherLink interface.  This interface provides an RS232
 *  port to a weather station console made by the same company.
 *
 *  This program is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU General Public License
 *  as published by the Free Software Foundation; either version 2
 *  of the License, or (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  20-Nov-1999   Lew Riley       First release reading data from the 
 *                                Davis hardware.  
 * 
 *  24-Nov-1999   Charlie Peck    Cleaned-up a bit.  Removed terminal, 
 *                                process, and signal handling code that 
 *                                we don't need.
 *
 *  24-Jan-2000   Lew Riley       Added Hi/Lo statistics (no times yet).
 *                                Changed output format -> line by line
 *                                with labels.
 *
 *  29-Jan-2000   Lew Riley       Added station time/date and started 
 *                                adding time stamps on Hi/Lo values. 
 *
 *   2-Feb-2000   Lew Riley       Redesigned data collection functions to
 *                                use a standard getData interface and to 
 *                                handle output in "verbose" mode.
 *
 *   4-Feb-2000   Lew Riley       Added wind chill and dew point and 
 *                                associated Hi/Lo values.
 * 
 *  13-Feb-2000   Lew Riley       Separated functions -> weather.h, weather.c 
 *                                Hi/Lo stats -> getHiLo.c
 *
 *  23-Feb-2000   Lew Riley       Removed daily rain.
*/
#include <stdlib.h>
#include <termios.h>
#include <unistd.h>
#include <fcntl.h>
#include <stdio.h>
#include "weather.h"

#define BAUDRATE B2400
//#define SERIALDEVICE "/dev/ttyS1"
//#define SERIALDEVICE "/dev/cu.USA19H3b1P1.1"
#define SERIALDEVICE "/dev/tty.USA19H3b1P1.1"
#define FALSE 0
#define TRUE 1

int main(int argc, char *argv[]) {
  struct termios oldtio, newtio, oldstdtio, newstdtio;
  int fd, debug_level = 0;
 
  /* Set the debug level.  0 = off, 1 = messages from weather value 
     functions, 2 = 1 plus messages from the serial interface functions.
  */ 
  if (argc < 2) {
    debug_level = 0; 
  } else {
    debug_level = atoi(argv[1]); 
  } 

  //debug_level = 2; // mcb debug

  if (1 || debug_level > 0) { // mcb debug
    printf("getWeather: debug_level = %d\n", debug_level); 
  }
  
  if ((receive_buffer = (unsigned char *)malloc(BUFFER_SIZE)) == NULL) {
    printf("getWeather: error allocating receive buffer (%d bytes).\n", 
	   BUFFER_SIZE);
    exit(-1);
  }
  
  /* Open serial port for reading and writing and not as controlling tty
     because we don't want to get killed if linenoise sends CTRL-C.  
  */
  fd = open(SERIALDEVICE, O_RDWR | O_NOCTTY);
  if (fd < 0) {
    printf("getWeather: error opening serial device.\n");
    perror(SERIALDEVICE); 
    exit(-1); 
  }
  
  /* Save the current serial port settings.
   */
  tcgetattr(fd, &oldtio); 
  tcgetattr(fd, &newtio);  // mcb added (so we have a valid starting structure)

  /* Set bps rate (the old way) and hardware flow control and 8n1 (8bit,no parity,1 stopbit).
     Also don't hangup automatically and ignore modem status.  Finally enable 
     receiving characters.
  */
  //newtio.c_cflag = BAUDRATE | CS8 | CLOCAL | CREAD ; // mcb this is orginal
  newtio.c_cflag |= ( CLOCAL | CREAD) ;

  cfsetispeed(&newtio, BAUDRATE) ; // set the bps rate (the new way) see http://www.easysw.com/~mike/serial/serial.html#2_5
  cfsetospeed(&newtio, BAUDRATE) ;
   
  
  // no parity (8N1):
  newtio.c_cflag &= ~PARENB;
  newtio.c_cflag &= ~CSTOPB;
  newtio.c_cflag &= ~CSIZE;
  newtio.c_cflag |= CS8;

  // harware flow control
  newtio.c_cflag |= CRTSCTS;

  /* Don't echo characters, we just want output from the device.  Don't 
     generate signals.  This is the quick and dirty way to do this, we should 
     use the specific masks for ECHO and ISIG but since we don't care about 
     having any of the items in this vector enabled we can just zero it.
  */
  newtio.c_lflag &= ~ISIG;
  newtio.c_lflag &= ~ECHO;
  newtio.c_lflag &= ~ECHOE;
  newtio.c_lflag &= ~ICANON; // raw mode
  
  /* Ignore bytes with parity errors and leave port raw and dumb.
   */
  newtio.c_iflag |= IGNPAR ;
  newtio.c_iflag &= ~(IXON | IXOFF | IXANY);  // disable software flow control
 
  /* Flush the I/O queue for the port and enable the new settings.
   */
  tcflush(fd, TCIFLUSH);
  tcsetattr(fd, TCSANOW, &newtio);
  
  /* Call the functions that collect the data from the Davis interface
     and write the results to stdout in metric form where appropriate.
  */
  
  while(1) {
	  /*
	  printf("Station Time                 :          "); 
	  printTimeStamp(getData(fd, 0x34, 0xC8, 2, debug_level), 
			 getData(fd, 0x44, 0xBE, 2, debug_level), 
			 debug_level); 
	  printf("\n"); 
	  */
	  
	  getInTemp     (fd, 1, debug_level);
	  getOutTemp    (fd, 1, debug_level);
	  getWindSpeed  (fd, 1, debug_level);
	  getWindDir    (fd, 1, debug_level); 
	  //getPressure   (fd, 1, debug_level);
	  //getBarTrend   (fd, 1, debug_level);
	  //getInHum      (fd, 1, debug_level);
	  //getOutHum     (fd, 1, debug_level);
	  //getRain       (fd, 1, debug_level);
	  //getWindChill  (fd, 1, debug_level);
	  //getDewPoint   (fd, 1, debug_level);
  }

  /* Put the serial port and the terminal back the way the were when
     we started.
  */
  tcsetattr(fd, TCSANOW, &oldtio); 
  tcsetattr(0, TCSANOW, &oldstdtio); 
  
  close(fd);
  exit(0);
}
