/*
 * Decompiled with CFR 0.152.
 */
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;

class Searcher {
    Searcher() {
    }

    public static void search(String filename, String needle, PatchBuddy pb) {
        File f = new File(filename);
        if (f.isHidden()) {
            return;
        }
        if (f.isDirectory()) {
            System.out.println("Recursing to  '" + filename + "'");
            String[] files = f.list();
            int i = 0;
            while (i < files.length) {
                Searcher.search(String.valueOf(filename) + "/" + files[i], needle, pb);
                ++i;
            }
            return;
        }
        if (!f.canRead()) {
            pb.report("Ignored '" + filename + "' can't read file");
            return;
        }
        if (!f.isFile()) {
            pb.report("Ignored'" + filename + "' not a normal file");
            return;
        }
        BufferedReader in = null;
        try {
            in = new BufferedReader(new FileReader(f));
        }
        catch (FileNotFoundException e) {
            return;
        }
        if (in == null) {
            return;
        }
        try {
            String firstline = in.readLine();
            if (firstline == null) {
                pb.report("Ignored '" + filename + "' not a Text MAX/MSP file (no 'max v2' signature)");
                return;
            }
            StringTokenizer toks = new StringTokenizer(firstline, " \t\f\r\n;", false);
            if (!toks.nextToken().equals("max") && !toks.nextToken().equals("v2")) {
                pb.report("Ignored '" + filename + "' not a Text MAX/MSP file (no 'max v2' signature)");
                return;
            }
        }
        catch (IOException ioe) {
            pb.report("Ignored '" + filename + "' file (can't read)");
            return;
        }
        catch (NoSuchElementException e) {
            pb.report("Ignored '" + filename + "' not a Text MAX/MSP file (can't read signature)");
            return;
        }
        Patcher patcherTree = null;
        Patcher here = null;
        Patcher nameme = null;
        try {
            int lineCount = 1;
            while (in.ready()) {
                String line = in.readLine();
                if (line != null) {
                    ++lineCount;
                    StringTokenizer toks = new StringTokenizer(line, " \t\f\r\n;", false);
                    try {
                        String linetype = toks.nextToken();
                        if (linetype.equals("#N") && toks.nextToken().equals("vpatcher")) {
                            String x = toks.nextToken();
                            String y = toks.nextToken();
                            String xd = toks.nextToken();
                            String yd = toks.nextToken();
                            if (patcherTree == null) {
                                here = patcherTree = new Patcher();
                                patcherTree.name = filename;
                                continue;
                            }
                            here = here.addChild();
                            continue;
                        }
                        if (!linetype.equals("#P")) continue;
                        if (here == null) {
                            System.err.println("Warning: line skipped (here is NULL) LINE:  " + line);
                            continue;
                        }
                        String ptype = toks.nextToken();
                        if (ptype.equals("pop")) {
                            nameme = here;
                            here = here.parent();
                            continue;
                        }
                        if (!ptype.equals("newobj") && !ptype.equals("newex") || toks.nextToken() == null || toks.nextToken() == null || toks.nextToken() == null) continue;
                        String id = toks.nextToken();
                        String objectname = toks.nextToken();
                        String args = new String();
                        while (toks.hasMoreTokens()) {
                            args = String.valueOf(args) + " " + toks.nextToken();
                        }
                        if (objectname.equals("p")) {
                            if (nameme != null && nameme.name == null) {
                                nameme.name = args.trim();
                                nameme = null;
                            } else {
                                System.err.println("got SUB-PATCHER name, " + args);
                                System.err.println("but nameme is null or named! at line, " + line);
                            }
                        }
                        if (objectname.lastIndexOf(needle) != -1) {
                            here.found = true;
                            continue;
                        }
                        if (args.lastIndexOf(needle) == -1) continue;
                        here.found = true;
                    }
                    catch (NoSuchElementException noSuchElementException) {
                        // empty catch block
                    }
                    continue;
                }
                break;
            }
        }
        catch (IOException ioe) {
            pb.report("Ignored '" + filename + "' not a valid MAX/MSP file (read error)");
            return;
        }
        if (patcherTree != null) {
            ArrayList list = new ArrayList();
            patcherTree.ListFound(list);
            pb.ShowListDialog(list);
        }
    }
}

