#ifndef SFU_CP_NETSENDER_H
#define SFU_CP_NETSENDER_H
/*
 * netsender, interface
 *
 * C to max/msp or pd communication
 *
 * Copyright: Mark Brady 2004
 *
 * see main.c for sample code/usage
 *
 */

#include <netinet/in.h>

typedef struct netsender_context_tag {
	int max_socket; /* max/msp/pd netsend socket */
	struct sockaddr_in max_addr, local_addr;
} NetsenderContext;

unsigned short netsender_init(const char * dest_ip, unsigned long dest_port, NetsenderContext* context) ;
// return 1 on init, 0 on fail

void netsender_shutdown(NetsenderContext* context) ;

ssize_t netsender_sendtomax(const char * socket_data, NetsenderContext* context) ;
// returns the count of bytes sent, including ;\n

#endif
